#include <QApplication>
#include <QWidget>
#include <QScreen>
#include <QDebug>

#include "subwindow.h"
#include "mainwindow.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    // 创建主窗口
    MainWindow mainWindow;

    // 创建子窗口
    SubWindow subWindow;

    // 获取系统中的显示器信息
    QList<QScreen*> screens = QGuiApplication::screens();
    qDebug()<<screens.size();

    if (screens.size() >= 2) {
        // 获取第二个显示器的几何信息
        QRect secondScreenGeometry = screens[1]->geometry();
        qDebug()<<screens[1]->geometry();
        // 将主窗口移动到第二个显示器
        mainWindow.setGeometry(screens[1]->geometry());
        mainWindow.move(secondScreenGeometry.topLeft());
    }

    if (screens.size() >= 2) {
        // 获取第一个显示器的几何信息
        QRect firstScreenGeometry = screens[0]->geometry();
        qDebug()<<screens[0]->geometry();
        // 将子窗口移动到第一个显示器
        subWindow.setGeometry(screens[0]->geometry());
        subWindow.move(firstScreenGeometry.topLeft());
    }

    mainWindow.show();
    subWindow.show();

    return app.exec();
}
